function residual = dynamic_resid(T, y, x, params, steady_state, it_, T_flag)
% function residual = dynamic_resid(T, y, x, params, steady_state, it_, T_flag)
%
% File created by Dynare Preprocessor from .mod file
%
% Inputs:
%   T             [#temp variables by 1]     double   vector of temporary terms to be filled by function
%   y             [#dynamic variables by 1]  double   vector of endogenous variables in the order stored
%                                                     in M_.lead_lag_incidence; see the Manual
%   x             [nperiods by M_.exo_nbr]   double   matrix of exogenous variables (in declaration order)
%                                                     for all simulation periods
%   steady_state  [M_.endo_nbr by 1]         double   vector of steady state values
%   params        [M_.param_nbr by 1]        double   vector of parameter values in declaration order
%   it_           scalar                     double   time period for exogenous variables for which
%                                                     to evaluate the model
%   T_flag        boolean                    boolean  flag saying whether or not to calculate temporary terms
%
% Output:
%   residual
%

if T_flag
    T = World_Economy_Cartel_cheaters.dynamic_resid_tt(T, y, x, params, steady_state, it_);
end
residual = zeros(76, 1);
residual(1) = T(33)+T(37)+params(23)*y(135)-y(97);
residual(2) = T(26)*(-exp(y(31)))+y(99)*(-T(38))+y(88)*(-(T(31)*params(4)*exp(y(31)*params(4))))+exp(y(31))*y(73)+params(23)*T(38)*y(137);
residual(3) = y(87)*(-(T(29)*params(4)*exp(y(32)*params(4))))+y(78)*y(48)*T(29)*params(4)*(params(4)-1)*exp(y(32)*(params(4)-1))+exp(y(32))*y(73)+params(23)*y(136)-y(98);
residual(4) = y(99)*(-T(39))+y(89)*(-(T(30)*params(4)*exp(y(33)*params(4))))+y(82)*y(51)*T(30)*params(4)*(params(4)-1)*exp(y(33)*(params(4)-1))+exp(y(33))*y(73)+params(23)*y(137)*T(39);
residual(5) = T(26)*T(40)+y(101)*(-T(41))+y(93)*(-T(32))+T(32)*y(91)+params(23)*T(41)*y(139);
residual(6) = y(101)*(-T(42))+y(93)*(-exp(y(35)))+exp(y(35))*y(92)+params(23)*y(139)*T(42);
residual(7) = y(93)*(-exp(y(36)))+exp(y(36))*y(90)+params(23)*y(138)-y(100);
residual(8) = T(44);
residual(9) = T(46);
residual(10) = T(48);
residual(11) = T(49);
residual(12) = T(50);
residual(13) = T(51);
residual(14) = T(47)+y(83)*T(52)+T(55)+params(23)*y(122)*exp(y(39))*params(6)*params(5)*exp(params(5)*(y(43)-y(117)))+T(56);
residual(15) = T(58)+params(23)*y(134)*(-exp(y(44)));
residual(16) = T(45)+y(79)*T(59)+y(76)*T(60)+params(23)*y(122)*exp(y(38))*params(6)*params(5)*exp(params(5)*y(45))+T(61);
residual(17) = exp(y(46))*y(72);
residual(18) = y(77)*(-params(7))+y(76)+T(34)*y(23)*(-(T(24)*(1-exp(y(16)))))+T(34)*T(24)*y(25);
residual(19) = params(4)*exp(y(32)*(params(4)-1))*T(29)*y(78)+y(77)+T(34)*y(24)*(-(T(24)*(1-params(7))));
residual(20) = T(8)*y(93)+y(69)*(-(params(11)*T(12)*T(62)))+y(68)*(-(params(11)*T(63)*T(64)));
residual(21) = (-params(7))*y(81)+y(80)+T(34)*y(26)*(-(T(24)*(1-exp(y(14)-y(60)))))+T(34)*y(28)*T(24)*exp((-y(60)));
residual(22) = params(4)*exp(y(33)*(params(4)-1))*T(30)*y(82)+y(81)+T(34)*(-(T(24)*(1-params(7))))*y(27);
residual(23) = y(73)*(-exp(y(52)))+y(71)*(-(T(5)*T(19)*T(16)*T(66)))+y(70)*(-(T(17)*T(3)*T(16)*T(67)))+y(69)*(-(T(14)*params(11)*T(65)))+exp(y(52))*y(68)+params(23)*y(140)-y(102);
residual(24) = T(20)*y(73)+params(23)*y(118)*(-(T(74)*T(77)))+params(23)*y(119)*(-(T(78)*(T(70)*T(80)*T(81)+T(71)*T(80)*T(83))))+params(23)*y(120)*T(87)+params(23)*y(121)*(-(exp((1-params(3))*y(112))*exp(T(1)*y(116))*params(3)*exp(params(3)*y(53))))+params(23)*y(122)*(-(T(20)*(1-params(10))));
residual(25) = (T(40)-exp(y(31)))*T(91)+y(75)*(-(params(1)*T(91)/T(28)))+T(4)*y(74)+y(72)*T(93)+y(71)*T(97)+y(70)*T(99)+y(68)*(-(T(64)*T(101)))+params(23)*y(123)*(-((-(T(91)*T(103)))/(T(26)*T(26))));
residual(26) = (T(40)-exp(y(31)))*T(104)+y(75)*T(105)+exp(y(55))*y(73)+params(23)*y(123)*(-((-(T(103)*T(104)))/(T(26)*T(26))));
residual(27) = exp(y(56))*y(71)+T(34)*y(22)*(-(exp(y(56))*T(24)));
residual(28) = y(74)*(-(T(21)*T(106)))+exp(y(57))*y(70);
residual(29) = T(107);
residual(30) = y(95)+params(23)*y(133)*(-params(16))+y(72)*(-(exp(y(54)*(1-params(3)))*exp(y(18)*params(3))*T(1)*exp(T(1)*y(59))))+y(71)*(-(T(5)*T(19)*T(16)*T(108)))+y(70)*(-(T(17)*T(3)*T(16)*T(109)))+y(68)*(-(T(64)*T(111)))+T(112)*(-params(17))*y(141);
residual(31) = T(115)+y(94)+T(117)+T(119)+T(121)+y(85)*T(122)+y(73)*T(123)+T(126)+T(127);
residual(32) = y(97);
residual(33) = y(98);
residual(34) = y(99);
residual(35) = y(100);
residual(36) = y(101);
residual(37) = y(102);
residual(38) = T(26)*T(128)+exp(y(67))*y(96);
residual(39) = exp(y(52))-T(9)^T(10);
residual(40) = exp(y(30))-params(11)*T(12)*T(14);
residual(41) = exp(y(57))-T(3)*T(15)*T(16)*T(17);
residual(42) = exp(y(56))-T(5)*T(16)*T(18)*T(19);
residual(43) = exp(y(46))-exp(T(1)*y(59))*exp(y(18)*params(3))*exp(y(54)*(1-params(3)));
residual(44) = exp(y(55))+T(20)+exp(y(32))+exp(y(31))+exp(y(33))+params(6)*exp(params(5)*y(16))*exp(y(9))+params(6)*exp(params(5)*(y(15)-y(60)))*exp(y(8))+params(6)*exp(params(5)*(y(14)-y(60)))*exp(y(10))-(exp(y(52))+exp(y(18))*(1-params(10)));
residual(45) = T(4)-T(21)*exp(y(57))^T(22);
residual(46) = 1-T(23)*(1+exp(y(114))-params(10));
residual(47) = T(24)-params(1)*T(26)/T(28);
residual(48) = y(47)-T(23)*(exp(y(45))*exp(y(105))+(1-exp(y(45)))*y(106)-params(6)*exp(params(5)*y(45)));
residual(49) = y(48)-(y(47)*params(7)+T(23)*(1-params(7))*y(107));
residual(50) = y(48)*params(4)*exp(y(32)*(params(4)-1))*T(29)-1;
residual(51) = T(23)*params(6)*params(5)*exp(y(45)*(params(5)-1))-T(23)*(exp(y(105))-y(106));
residual(52) = y(50)-T(23)*(exp(y(105))*exp(y(43)-y(117))+(1-exp(y(43)-y(117)))*y(109)-params(6)*exp(params(5)*(y(43)-y(117))));
residual(53) = y(51)-(params(7)*y(50)+T(23)*(1-params(7))*y(110));
residual(54) = y(51)*params(4)*exp(y(33)*(params(4)-1))*T(30)-1;
residual(55) = T(129);
residual(56) = exp(y(38))-(exp(y(9))*(1-exp(y(16)))+params(7)*exp(y(41)));
residual(57) = exp(y(37))-(exp(y(8))*(1-exp((-y(60)))*exp(y(15)))+params(7)*exp(y(40)));
residual(58) = exp(y(39))-(exp(y(10))*(1-exp((-y(60)))*exp(y(14)))+params(7)*exp(y(42)));
residual(59) = exp(y(41))-((1-params(7))*exp(y(12))+T(29)*exp(y(32)*params(4)));
residual(60) = exp(y(40))-((1-params(7))*exp(y(11))+exp(y(31)*params(4))*T(31));
residual(61) = exp(y(42))-((1-params(7))*exp(y(13))+T(30)*exp(y(33)*params(4)));
residual(62) = exp(y(36))-exp(y(9))*exp(y(16));
residual(63) = T(32)-exp(y(8))*exp((-y(60)))*exp(y(15));
residual(64) = exp(y(35))-exp(y(10))*exp((-y(60)))*exp(y(14));
residual(65) = T(8)-(exp(y(35))+exp(y(36))+T(32));
residual(66) = y(60)-x(it_, 1);
residual(67) = y(59)-(x(it_, 2)+params(16)*y(21)+params(17)*y(29));
residual(68) = exp(y(67))-exp(y(15));
residual(69) = y(61)-(y(30)-y(1));
residual(70) = y(62)-(y(32)-y(3));
residual(71) = y(63)-(log(exp(y(31))+exp(y(33)))-log(exp(y(2))+exp(y(4))));
residual(72) = y(64)-(y(36)-y(7));
residual(73) = y(65)-(log(T(32)+exp(y(35)))-log(exp(y(5))+exp(y(6))));
residual(74) = y(66)-(y(52)-y(17));
lhs = y(103);
rhs = y(133);
residual(75) = lhs - rhs;
lhs = y(104);
rhs = y(21);
residual(76) = lhs - rhs;

end
